Attribute VB_Name = "mdConstrainSeparationLineToLine"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Rem Convenience zFunction to constrain the separation between a line and another line

Sub ConstrainSeparationLineToLine(line1 As aLine, line2 As aLine)

Rem To get the global objects like application, part, workplane, sketch
GetApplicationObject

Dim Part As PartDocument
Set Part = app.GetActiveDoc

Dim wp As aWorkplane
Set wp = Part.GetActiveWorkplane

Dim sketch As aSketch
Set sketch = Part.GetActiveSketch

If (line1.GetGeometricForm.GetDirection.IsParallel(line2.GetGeometricForm.GetDirection, False)) Then
    
    Dim zcon As zLLLinearDim
    Set zcon = app.GetClass("LLLinearDim").CreateLLLinearDim(line1, line2)
    wp.CreateConstraint zcon
    
Else
 
    Dim con As zAngularDim
    Set con = app.GetClass("AngularDim").CreateAngularDim(line1, line2)
    wp.CreateConstraint con
    
End If

End Sub


